/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.block.OstrichNestBlock;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.entity.ai.OstrichBreedGoal;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class OstrichEntity
extends Animal
implements ItemSteerable,
ILexiconEntry {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BUILDING_NEST = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LAYING_EGG = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedSteering boostHelper;
    private int nestBuildingCounter;
    private int layingEggCounter;

    public OstrichEntity(EntityType<? extends OstrichEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.boostHelper = new ItemBasedSteering(this.f_19804_, BOOST_TIME, SADDLED);
    }

    public static boolean checkOstrichSpawnRules(EntityType<OstrichEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.OSTRICH_SPAWNABLE_ON) && OstrichEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.OSTRICH.get().m_20615_((Level)world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, OstrichConfig.health()).m_22268_(Attributes.f_22279_, OstrichConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new OstrichBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LayEggGoal(this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.OSTRICH_FOOD, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, OstrichEntity.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(IS_BUILDING_NEST, (Object)false);
        this.f_19804_.m_135372_(IS_LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)true);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasEgg", this.hasEgg());
        this.boostHelper.m_20847_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasEgg(compound.m_128471_("HasEgg"));
        this.boostHelper.m_20852_(compound);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.isBuildingNest() && this.nestBuildingCounter >= 1 && this.nestBuildingCounter % 7 == 0) {
            BlockPos pos = this.m_20183_();
            this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49992_.m_49966_()));
        }
    }

    public int m_5792_() {
        return OstrichConfig.maxSpawnedInChunk();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (BOOST_TIME.equals(key) && this.m_9236_().f_46443_) {
            this.boostHelper.m_20844_();
        }
        super.m_7350_(key);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.OSTRICH_FOOD);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasEgg()) {
            this.m_19998_((ItemLike)ModItems.OSTRICH_EGG.get());
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.98f;
    }

    public boolean m_6040_() {
        return false;
    }

    public boolean isBuildingNest() {
        return (Boolean)this.f_19804_.m_135370_(IS_BUILDING_NEST);
    }

    public void setBuildingNest(boolean building) {
        this.nestBuildingCounter = building ? 1 : 0;
        this.f_19804_.m_135381_(IS_BUILDING_NEST, (Object)building);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAYING_EGG);
    }

    public void setLayingEgg(boolean layingEgg) {
        this.layingEggCounter = layingEgg ? 1 : 0;
        this.f_19804_.m_135381_(IS_LAYING_EGG, (Object)layingEgg);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    protected SoundEvent m_7515_() {
        return ModSounds.OSTRICH_AMBIENT.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean isLexicon;
        boolean breedingItem = this.m_6898_(player.m_21120_(hand));
        boolean bl = isLexicon = player.m_21205_().m_41720_() == ModItems.LEXICON.get();
        if (!(breedingItem || isLexicon || this.m_20160_() || this.m_6162_() || player.m_36341_())) {
            if (!this.m_9236_().f_46443_ && OstrichConfig.canBeRidden()) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public LivingEntity m_6688_() {
        Entity passenger = this.m_146895_();
        if (passenger instanceof Player) {
            return (Player)passenger;
        }
        return null;
    }

    public boolean m_6746_() {
        return this.boostHelper.m_217032_(this.m_217043_());
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.boostHelper.m_274606_();
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVec) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.9f;
    }

    public double m_6048_() {
        return 1.0;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OSTRICH;
    }

    private static class LayEggGoal
    extends MoveToBlockGoal {
        private final OstrichEntity ostrich;
        private boolean isAboveDestination;

        public LayEggGoal(OstrichEntity creature, double speedIn) {
            super((PathfinderMob)creature, speedIn, 16);
            this.ostrich = creature;
        }

        public boolean m_8036_() {
            return (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg()) && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && (this.ostrich.hasEgg() || this.ostrich.isBuildingNest() || this.ostrich.isLayingEgg());
        }

        protected void m_25624_() {
            BlockPos blockpos = this.m_6669_();
            Path path = this.f_25598_.m_21573_().m_26524_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, 0);
            this.f_25598_.m_21573_().m_26536_(path, this.f_25599_);
        }

        protected BlockPos m_6669_() {
            if (this.ostrich.m_9236_().m_8055_(this.f_25602_).m_60734_() == ModBlocks.OSTRICH_NEST.get()) {
                return this.f_25602_;
            }
            return this.f_25602_.m_7494_();
        }

        public void m_8037_() {
            BlockPos blockpos = this.m_6669_();
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                this.isAboveDestination = false;
                ++this.f_25601_;
                if (this.m_8064_()) {
                    Path path = this.f_25598_.m_21573_().m_26524_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, 0);
                    this.f_25598_.m_21573_().m_26536_(path, this.f_25599_);
                }
            } else {
                this.isAboveDestination = true;
                --this.f_25601_;
            }
            if (!this.ostrich.m_20069_() && this.m_25625_()) {
                Level world = this.ostrich.m_9236_();
                if (world.m_8055_(this.f_25602_).m_60734_() == ModBlocks.OSTRICH_NEST.get()) {
                    BlockState state = world.m_8055_(this.f_25602_);
                    if (!((Boolean)state.m_61143_((Property)OstrichNestBlock.EGG)).booleanValue()) {
                        if (this.ostrich.layingEggCounter < 1) {
                            this.ostrich.setLayingEgg(true);
                        } else if (this.ostrich.layingEggCounter > 150) {
                            world.m_5594_(null, this.f_25602_, ModSounds.OSTRICH_EGG_LAYING.get(), SoundSource.BLOCKS, 0.5f, 0.9f);
                            world.m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)OstrichNestBlock.EGG, (Comparable)Boolean.valueOf(true)), 3);
                            this.ostrich.setHasEgg(false);
                            this.ostrich.setLayingEgg(false);
                        }
                        if (this.ostrich.isLayingEgg()) {
                            ++this.ostrich.layingEggCounter;
                        }
                    }
                } else {
                    if (this.ostrich.nestBuildingCounter < 1) {
                        this.ostrich.setBuildingNest(true);
                    } else if (this.ostrich.nestBuildingCounter > 100) {
                        world.m_5594_(null, this.f_25602_, SoundEvents.f_12581_, SoundSource.BLOCKS, 0.9f, 0.9f);
                        world.m_7731_(this.f_25602_.m_7494_(), ModBlocks.OSTRICH_NEST.get().m_49966_(), 3);
                        this.f_25602_ = this.f_25602_.m_7494_();
                        this.ostrich.setBuildingNest(false);
                    }
                    if (this.ostrich.isBuildingNest()) {
                        ++this.ostrich.nestBuildingCounter;
                    }
                }
            } else {
                this.ostrich.setLayingEgg(false);
                this.ostrich.setBuildingNest(false);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.ostrich.setLayingEgg(false);
            this.ostrich.setBuildingNest(false);
        }

        protected boolean m_25625_() {
            return this.isAboveDestination;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            if (worldIn.m_8055_(pos).m_60734_() == ModBlocks.OSTRICH_NEST.get()) {
                return (Boolean)worldIn.m_8055_(pos).m_61143_((Property)OstrichNestBlock.EGG) == false;
            }
            if (worldIn.m_8055_(pos).m_60734_() == Blocks.f_49992_) {
                return worldIn.m_46859_(pos.m_7494_());
            }
            return false;
        }
    }
}

